qui {

noi {
	/*************************************************/
	/*** Step 2.6.1. Motivating example 		    **/
	/*************************************************/
}

/* 2.6.1.0. Identify motivating examples in the data */
cd ..
cd ".\4. Master data"
clear all
use master_data
	
	* Motivating example 3: p-values
	sum cntrycode if cntry == "Ukraine"
	local example = r(mean)
	
	* Identify example
	noi list cntry year mother_country_name if independence_years == 0 & cntrycode == `example'

	* Load (placebo) independence gaps
	clear all
	cd ..
	cd ".\3. Intermediary results\3.4. Intermediaries" 	
	use PIDD1_`example', clear
	cd ..
	cd ..
	
	* Generate placebo-independence years
	gen pindependence_years = .
	foreach year of numlist $startyear / 2016 {
		sum independence_years if year == `year' & cntrycode == `example'
		cap replace pindependence_years = `r(mean)' if year == `year'
		}
		
	* generate placebo country codes
	gen pcntrycode = cntrycode if cntrycode == `example'
	replace pcntrycode = 1000*`example'+cntrycode if cntrycode != `example'
	
	* Generate (placebo) independence dividends
	gen PTDIDD = .
	levelsof pcntrycode if lgap_`example' != ., local(countries)	
	foreach cntry in `countries' {
		sum lgap_`example' if pindependence_years >= -10 & pindependence_years <= -1 & pcntrycode == `cntry'
		replace PTDIDD = lgap_`example'-`r(mean)' if pcntrycode == `cntry'
		}
	
	* Show construction of p-values for selected years
	local count = 0
	foreach year of numlist 1 5 10 20 {
		local count = `count'+1
		_pctile PTDIDD if pindependence_years == `year' & pcntrycode > 400, percentile(2.5 97.5)
		local p25_e = r(r1)
		local p975_e = r(r2)
		sum PTDIDD if pindependence_years == `year' & pcntrycode > 400
		local pe = `r(mean)'
		local p25_n = `pe'+invttail((`r(N)'-1),.975)*`r(sd)'
		local p975_n = `pe'+invttail((`r(N)'-1),.025)*`r(sd)'
		sum PTDIDD if pindependence_years == `year' & pcntrycode == `example'
		histogram PTDIDD if pindependence_years == `year', fraction normal blcolor(gs0) bfcolor(gs0*.25) addplot(pci 0 `r(mean)' .15 `r(mean)', lc(red) lw(thick)) bgcolor(white) graphregion(color(white)) legend(off) xline(`p25_e' `p975_e', lc(gs0) lp(dash)) xline(`p25_n' `p975_n', lc(gs6) ) yla(0 "0%" .1 "10%" .2 "20%" .3 "30%" .4 "40%", ang(h)) ytitle("Fraction of placebo estimates", size(large)) xtitle("Placebo independence dividend estimate", size(large))
		cd ".\5. TeX results"
		graph export  figure7_`count'.pdf, replace
		cd ..
		}
		
	preserve
	keep  if pindependence_years == 5
	sort PTDIDD
	noi di "Ukranian placebo countries with the most negative per capita GDP discrepancies in 1996 (T=5):"
	noi list cntrycode cntry year independence_years pindependence_years PTDIDD if _n <= 5
	restore
	
	* Compute full-path p-values
	gen pvalue = .
	foreach year of numlist -10/30 {
		local pointestimate
		sum PTDIDD if pindependence_years == `year' & pcntrycode == `example'
		cap local pointestimate = `r(mean)'
		sum PTDIDD if pindependence_years == `year' & pcntrycode > 400
		cap replace pvalue = 2*ttail(`r(N)',abs(`pointestimate'/`r(sd)')) if pcntrycode == `example' & pindependence_years == `year' 
		}
		
	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
